#include	"Config.h"
volatile unsigned char DisplayBCDBuf[4];
void lcd_init()
{
	//引腳配置
	
	_pbs1=0xff;
	_pcs0=0xff;
	_pcs1=0xff;
	
	//寄存器配置
	
	_lcdc=0x00;
	_pumpen=1;
	_lcden=1; 
	fun_LCD_Full(0x00);

}
void fun_LCD_Full(u8 lU8v_lcd_data)
{
     u8 i;
	 for(i=0;i<LU8C_LCD_SEG;i++)	         
	 {
	    gu8a_lcd_buff[i].U8=lU8v_lcd_data;
	 }
}

#define      a  	0x0040
#define      b		0x0001
#define      c   	0x0020
#define      d   	0x0200
#define      e   	0x0100
#define      f   	0x0400
#define      g   	0x0010
#define      h   	0x0002

//   __		A
//  |  |  F	  B
//   __		G
//  |  |  E   C
//   __ 。  D   H

const u16 gu16c_Lcd_Table[]=
{
	a + b + c + d + e + f,						// Displays "0"  // 0
	b + c,										// Displays "1"  // 1
	a + b + d + e + g,							// Displays "2"  // 2
	a + b + c + d + g,							// Displays "3"  // 3
	b + c + f + g,								// Displays "4"  // 4
	a + c + d + f +g,							// Displays "5"  // 5
	a + c + d + e + f + g,						// Displays "6"  // 6
	a + b + c,									// Displays "7"  // 7
	a + b + c + d + e + f + g,					// Displays "8"  // 8
	a + b + c + d + f + g,						// Displays "9"  // 9
	a + b + c + e + f + g,						// Displays "A"  // 10
	c + d + e + f + g,							// Displays "B"  // 11
	a + d + e + f,								// Displays "C"  // 12
	b + c + d + e + g,							// Displays "D"  // 13
	a + d + e + f + g,							// Displays "E"  // 14
	a + e + f + g,								// Displays "F"  // 15
	a + c + d + e + f,							// Displays "G"  // 16
	b + c + e + f + g,							// Displays "H"  // 17
	e + f,										// Displays "I"  // 18
	b + c + d + e,								// Displays "J"  // 19
	b + d + e + f + g,							// Displays "K"  // 20
	d + e + f,									// Displays "L"  // 21
	a + c + e + g,								// Displays "M"  // 22
	a + b + c + e + f,							// Displays "N"  // 23
	c + e + g,									// Displays "n"  // 24
	c + d + e + g,								// Displays "o"  // 25
	a + b + c + d + e + f,						// Displays "O"  // 26
	a + b + e + f + g,							// Displays "P"  // 27
	a + b + c + f + g,							// Displays "Q"  // 28
	e + g,										// Displays "r"  // 29
	a + c + d + f +g,							// Displays "S"  // 30
	d + e + f + g,								// Displays "t"  // 31
	a + e + f , 								// Displays "T"  // 32
	b + c + d + e + f,							// Displays "U"  // 33
	c + d + e,									// Displays "v"  // 34
	b + d + f + g,								// Displays "W"  // 35
	b + c + d + f + g,							// Displays "Y"  // 36
	a + b + d + e + g,							// Displays "Z"  // 37
	g,											// Displays "-"  // 38
	b,											// Displays "'"  // 39
	0,											// Displays " "  // 40
	a + b + c + d + e + f + g + h 				// Displays "8."  // 41			
}; 

void LCD_Number_Display(u16 DisplayNum,u8 Dot_Mode)
{
	unsigned char i,j;
	u16 DisplayData,lu8_Bufdata;
    DisplayData = DisplayNum;
	for(i=0;i<4;i++)
	{
		DisplayBCDBuf[i]=DisplayNum%10;
		DisplayNum/=10;
	}
	// 去除高位0的顯示
	if (DisplayData < 100)
	{
		DisplayBCDBuf[2] = CHAR_OFF;
		DisplayBCDBuf[3] = CHAR_OFF;

	}
	else if (DisplayData < 1000)
	{
		DisplayBCDBuf[3] = CHAR_OFF;
	}
	for(i=0;i<4;i++)
	{
		j=i*3;
		lu8_Bufdata=DisplayBCDBuf[i];
		gu8a_lcd_buff[j].U8=gu16c_Lcd_Table[lu8_Bufdata];
		gu8a_lcd_buff[j+1].U8=(gu16c_Lcd_Table[lu8_Bufdata]>>4);
		gu8a_lcd_buff[j+2].U8=(gu16c_Lcd_Table[lu8_Bufdata]>>8);
	}
	if(Dot_Mode == 0)
	{
	}
	else if(Dot_Mode == 2)
	{
		gu8a_lcd_buff[3].U8 |=0x02;		
	}
	else if(Dot_Mode == 3)
	{
		gu8a_lcd_buff[6].U8 |=0x02;			
	}

}

void LCD_Display_Lo()
{
	gu8a_lcd_buff[0].U8=gu16c_Lcd_Table[CHAR_o];
	gu8a_lcd_buff[1].U8=(gu16c_Lcd_Table[CHAR_o]>>4);
	gu8a_lcd_buff[2].U8=(gu16c_Lcd_Table[CHAR_o]>>8);	
	gu8a_lcd_buff[3].U8=gu16c_Lcd_Table[CHAR_L];
	gu8a_lcd_buff[4].U8=(gu16c_Lcd_Table[CHAR_L]>>4);
	gu8a_lcd_buff[5].U8=(gu16c_Lcd_Table[CHAR_L]>>8);//"Lo"
	gu8a_lcd_buff[6].U8=gu16c_Lcd_Table[CHAR_OFF];
	gu8a_lcd_buff[7].U8=(gu16c_Lcd_Table[CHAR_OFF]>>4);
	gu8a_lcd_buff[8].U8=(gu16c_Lcd_Table[CHAR_OFF]>>8);
}

void LCD_Display_HI()
{
	gu8a_lcd_buff[0].U8=gu16c_Lcd_Table[CHAR_I];
	gu8a_lcd_buff[1].U8=(gu16c_Lcd_Table[CHAR_I]>>4);
	gu8a_lcd_buff[2].U8=(gu16c_Lcd_Table[CHAR_I]>>8);	
	gu8a_lcd_buff[3].U8=gu16c_Lcd_Table[CHAR_H];
	gu8a_lcd_buff[4].U8=(gu16c_Lcd_Table[CHAR_H]>>4);
	gu8a_lcd_buff[5].U8=(gu16c_Lcd_Table[CHAR_H]>>8);//"HI"
	gu8a_lcd_buff[6].U8=gu16c_Lcd_Table[CHAR_OFF];
	gu8a_lcd_buff[7].U8=(gu16c_Lcd_Table[CHAR_OFF]>>4);
	gu8a_lcd_buff[8].U8=(gu16c_Lcd_Table[CHAR_OFF]>>8);
}





void LCD_test(u32 data)
{
//	u8 lu8_count=0;
	//	LCD Init
	_pbs1	=	0b11111111;	//
	_pcs0	=	0b11111111;	//
	_pcs1	=	0b11111111; //SEG0~SEG11
	_lcdc 	=	0b10000101;	//SET COM2, Pump ,LCD Enable
	fun_LCD_Full(0x00);
	LCD_Number_Display(1234,0);
	while(1)
	{
		GCC_CLRWDT();
//		fun_LCD_Full(0x00);
//		LCD_Number_Display(lu8_count,0);
//		lu8_count++;
//		if(lu8_count>10)
//		{
//			lu8_count=0x00;
//		}
//		GCC_DELAY(10000);
	}
}